'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit

Dim fso, oFile, objArgs, Text, attrib, file

file = "D:\Documenti\test.pdf"  ' File da analizzare.

' Try to get a file as an argument.
Set objArgs = WScript.Arguments    ' Create object.
If objArgs.Count > 0 Then _
    file = objArgs(0)              ' First argument

' Create FileSystemObject object to access the file system.
Set fso = WScript.CreateObject("Scripting.FileSystemObject")

If fso.FileExists(file) Then       ' Check whether file exists.
    Set oFile = fso.GetFile(file)  ' Get file handle object.
    ' Now we try to retrieve the file information.
    Text = "File: " & vbTab & oFile.Name & vbCrLf ' Retrieve filename.

    ' File dates (created, modified, accessed)
    Text = Text & "Created: " & vbTab & oFile.DateCreated & vbCrLf 
    Text = Text & "Modified: " & vbTab & oFile.DateLastModified & vbCrLf
    Text = Text & "Accessed: " & vbTab & _
           oFile.DateLastAccessed & vbCrLf

    ' Decode attributes.
    Text = Text & "Attributes " & vbTab
    attrib = oFile.Attributes

    ' This is the read-only attribute.
    If (attrib And &H01) > 0 Then Text = Text & "r "
    ' This is the hidden attribute.
    If (attrib And &H02) > 0 Then Text = Text & "h "
    ' This is the system attribute.
    If (attrib And &H04) > 0 Then Text = Text & "s "
    ' This is the archive attribute.
    If (attrib And &H20) > 0 Then Text = Text & "a "
    ' This is the compressed attribute in Windows NT.
    If (attrib And &H800) > 0 Then Text = Text & "c "

    WScript.Echo Text           ' Show result.
Else
    WScript.Echo "Error: File " & file & " not found"
End If 

'*** End